<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
//$page_breadcrumb = "Generate Test Cases";
//$page_h1 = "Generate Test Cases &amp; Start Testing (1 of 2)";
$page_title = "SS - Save Test Selections";
$page_breadcrumb = "Generate Test Cases &amp; Start Testing (2 of 2)";
$page_h1 = "Reviewing Test Selections &amp; Saving to Log Drive";

include "ft_ss_need_logs.php";
include_once('../include/ss-global.php');

if ($ftlogs_mounted == 1) { // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.

	// savetestconfigfile.php receives several form variables.
	// Read in these form variables.
	// simple string variables
	$toolname = $_POST['toolname'];
	$toolversion = $_POST['toolversion'];
	$se_other_name = $_POST['se_other_name'];

	// array/multivalue variables
	$engines = $_POST['engines'];
	$datasets = $_POST['datasets'];
	$basic = $_POST['basic'];
	$logical = $_POST['logical'];
	$unicode = $_POST['unicode'];
	$tool_defined = $_POST['tool_defined'];
	$special = $_POST['special'];
	$regex = $_POST['regex'];
	
echo '<p><img src="/images/info_black-128x128.png" alt="" height="24" width="24" style="margin:-1px 0;">Please review the test selections you made. If anything is incorrect, use the browser\'s back button to return to the previous page and make any corrections.<br>';	
echo '<form method="POST" action="selectdataset.php"> ';
echo '<h2 style="font-size:1.7em; color:#008000"><b>1 Tool Name and Version</b><br></h2>';
echo '<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">';
echo '<p>';
echo 'Tool name: &nbsp;&nbsp;&nbsp;&nbsp;<i>'.$toolname.'</i><br>';
echo '<input name="toolname" value="'.$toolname.'" type="hidden">';
echo 'Tool version: &nbsp;<i>'.$toolversion.'</i><br></p>';
echo '<input name="toolversion" value="'.$toolversion.'" type="hidden">';
echo '</div><br>';
?>	

<h2 style="font-size:1.7em; color:green"><b>2 Search Engines to Test</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!-- <p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->

<p>Search engines you will test for the tool:<br>
<?php // search engines
foreach($engines_dict as $key => $value){
	if (in_array($key, $engines)){ // user selected this search engine type
		echo '<input name="engines[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';		
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="engines[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="engines[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}
}	
echo '</p>';
echo '<p>If Other is selected, name of the other search engine:&nbsp; <i>'.$se_other_name.'</i></p>';
echo '<input name="se_other_name" value="'.$se_other_name.'" type="hidden">';
?>
</div><br>

<h2 style="font-size:1.7em; color:green"><b>3 Data Sets to Test</b><br></h2>
<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">
<!-- <p style="font-family: Trebuchet MS,Tahoma,Verdana,Arial,sans-serif;"> -->

<p>Data sets that you will test for the tool:<br>
<?php // print out a list of the data sets that can be selected
foreach($datasets_dict as $key => $value){
	if (in_array($key, $datasets)){ // user selected this data set
		echo '<input name="datasets[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';		
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="datasets[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="datasets[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}
}	
?>
</p>	
</div><br>

<h2 style="font-size:1.7em; color:green"><b>4 Tool Features to Test</b><br></h2>
<br>
    
    <h3 style="font-size:1.6em; color:#9D0F19"><b>Basic Search Features</b></h3>
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
        url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

<!--		<p><input name="basic[]" value="ft-ss-01" type="checkbox"> &nbsp;Simple search. Test that the tool can find a single ASCII string.<br> 
        <input name="basic[]" value="ft-ss-02" type="checkbox"> &nbsp;Substring match and ignore case. Test the substring match and ignore case features of the tool.<br> 
        <input name="basic[]" value="ft-ss-03" type="checkbox"> &nbsp;Whole word search. Test searching for a whole word match vs a substring match.</p>-->

		<p>Basic string search features:<br>

<?php // print out a list of the "basic" test cases
$seen_ft_ss_02 = 0; // false
	
foreach($basic_dict_extended as $key => $value){
	if (in_array($key, $basic)){ // user selected this test
		echo '<input name="basic[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';		
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	

		if ($key == "FT-SS-02a" || $key == "FT-SS-02b"){ // if we see FT-SS-02a or FT-SS-02b, pass along the single value of FT-SS-02, i.e., FT-SS-02a and FT-SS-02b map to FT-SS-02
			if (!$seen_ft_ss_02){ // if we haven't already seen an FT-SS-02*/created a hidden input for FT-SS-02, do it
								  //  now. if we have seen an FT-SS-02*/created a hidden input for FT-SS-02, do nothing
				$seen_ft_ss_02 = 1; // true
				echo '<input name="basic[]" value="FT-SS-02" type="hidden">';			
			}
		} else { // else, print the hidden input here
			echo '<input name="basic[]" value="'.$key.'" type="hidden">';
		}
		
	} else { // not selected
		echo '<input name="basic[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}
}	
?>
	</p>
	</div><br>  
		
      <!--<h2 style="font-size:1.6em">Operations on Removable Media</h2>-->  
<!--      <h3 style="font-size:1.6em; color:#9D0F19"><b>Operations on Removable Media</b></h3>-->
    <h3 style="font-size:1.6em; color:#9D0F19"><b>Logical Combinations</b></h3>
 	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
    url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

        <p>Logical combinations do you want to test:<br>
<?php // logical combination test cases
foreach($logical_dict as $key => $value){
	if (in_array($key, $logical)){ // user selected this test
		echo '<input name="logical[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';		
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="logical[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="logical[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}
}	
?>		
		</p>		
    </div><br>

    <h3 style="font-size:1.6em; color:#9D0F19"><b>Search Unicode Text</b></h3>
 	<div style="padding: .5em 1em .25em 1em; background: #eeeeee 
    url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

        <p>Unicode searches:<br>
<?php // unicode 
foreach($unicode_dict as $key => $value){
	if (in_array($key, $unicode)){ // user selected this test
		echo '<input name="unicode[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';		
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="unicode[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="unicode[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}	
}	
?>
		</p>
    </div><br>
	
<!--	  <h2 style="font-size:1.6em">Operations on Partitions</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Search Tool Defined Queries</b></h3> 
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

        <p>Tool pre-defined queries: <br>
<?php // pre-defined queries 
foreach($tool_defined_dict as $key => $value){
	if (in_array($key, $tool_defined)){ // user selected this test
		echo '<input name="tool_defined[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';	
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="tool_defined[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="tool_defined[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}	
}	
?>
		</p>
	</div><br>

<!--      <h2 style="font-size:1.6em">Error Condition Tests</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Special Cases</b></h3> 
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

        <p>Special situations: <br>
<?php // special
foreach($special_dict as $key => $value){
	if (in_array($key, $special)){ // user selected this test
		echo '<input name="special[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';	
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="special[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="special[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}
}	
?>
		</p><p><b>*</b>Note: some tests are only available for the Windows data set.</p>
	</div><br>

<!--      <h2 style="font-size:1.6em">Hash Operations and Hashes</h2>-->
	<h3 style="font-size:1.6em; color:#9D0F19"><b>Regular Expressions</b></h3>
	<div style="padding: .5em 1em .25em 1em; background: #eeeeee url(/images/ui-bg_highlight-soft_100_eeeeee_1x100.png) 50% top repeat-x;">

        <p>Regular expression searches: <br>
<?php // regular expressions
foreach($regex_dict as $key => $value){
	if (in_array($key, $regex)){ // user selected this test
		echo '<input name="regex[]" value="'.$key.'" type="checkbox" disabled checked>&nbsp; '.$value.' <br>';	
		// note: b/c the checkboxes we're printing are disabled, no value will pass through to next page, 
		// hence 2nd hidden input  	
		echo '<input name="regex[]" value="'.$key.'" type="hidden">';
	} else { // not selected
		echo '<input name="regex[]" value="'.$key.'" type="checkbox" disabled>&nbsp; '.$value.' <br>';
	}
}	
?>	
		</p>	
</div><br>
		
<input value=" Continue " type="submit">         
</form>
</p>

<?php
/*
*/
//include "ft_ss_home_links.php";
?>
<?php
}  // endif($ftlogs_mounted==1)
include "ft_ss_tail.php";
?>

